function load {
    kill @e[tag=cutscene]
    kill @e[tag=freddy_walking_cutscene]
    summon item_display -4.0 -51.0 265.0 {Rotation:[147.0f, 40.0f],item:{id:"minecraft:carrot_on_a_stick", Count:1b}, Tags:["cutscene","outside"]}
    summon item_display -22.0 -56.5 220.5 {Rotation:[10.0f, 0.0f],item:{id:"minecraft:carrot_on_a_stick", Count:1b}, Tags:["cutscene","stage"]}
    summon item_display -7.3 -57.0 217.5 {Rotation:[-32.0f, 46.0f],item:{id:"minecraft:carrot_on_a_stick", Count:1b}, Tags:["cutscene","another_room"]}
    summon item_display -13.0 -56.25 222.0 {Rotation:[0.0f, 50.5f],item:{id:"minecraft:carrot_on_a_stick", Count:1b}, Tags:["cutscene","freddy_walking"]}
    summon item_display -19.178 <%-56.51759+0.35%> 195.854 {Rotation:[-12.0f,16.0f],item:{id:"minecraft:carrot_on_a_stick", Count:1b}, Tags:["cam_2b_cutscene","cutscene"]}
    summon item_display -23.5 -58.0 195.3 {item:{id:"minecraft:carrot_on_a_stick", Count:1b}, Tags:["cutscene","office_cutscene"]}
    function audio:ambient/stop
    scoreboard players set enable_remix ak.state 0
    scoreboard players set remix_mode_active ak.state 0
    fill -63 -60 185 16 -61 243 cave_air replace fire
    # say Loaded cutscene entities!
}


function cutscene_1_classic {
    stopsound @a master generic.lobby.loop
    tag @a remove crosshair
    stopsound @a master 
    scoreboard players set cutscene_active ak.state 1
    time set midnight
    sequence {
        title @a times 20 40 0
        title @a title ""
        title @a subtitle {"text":"B","font":"cursor"}
        delay 20t
        title @a times 20 40 10
        title @a subtitle ""
        title @a actionbar {"text":"B","font":"cursor"}
        title @a title {"text":"L","font":"cursor"}
        execute at @a run playsound minecraft:entity.firework_rocket.blast_far master @a ~ ~ ~ 100 1 1
        setblock -6 -56 219 light
        setblock -4 -56 222 light
        setblock -4 -56 217 light
        setblock -4 -60 217 light
        setblock -4 -60 222 light
        setblock -8 -60 222 light
        setblock -8 -60 217 light
        setblock -8 -56 217 light
        setblock -8 -56 222 light
        gamemode spectator @a
        spectate @e[tag=cutscene,tag=outside,limit=1] @p
        delay 150t
        spectate @e[tag=cutscene,tag=stage,limit=1] @p
        function animatronic:generic/spawn
        delay 280t
        spectate @e[tag=cutscene,tag=another_room,limit=1] @p
        delay 87t
        fill -8 -60 222 -4 -56 217 air replace light
        execute as @e[tag=animatronic] at @s run function animatronic:generic/stop_performing
        delay 70t
        spectate @e[tag=cutscene,tag=stage,limit=1] @p
        delay 70t
        function audio:ambient/start
        function night:start_night_1
        kill @e[tag=dummy]
        scoreboard players set cutscene_active ak.state 0
    }
}

function tick {
    execute if score cutscene_active ak.state matches 1 run {
        execute at @a run spectate @e[tag=cutscene,limit=1,sort=nearest] @p
    }

    execute if score enable_remix ak.state matches 1 positioned -24 -60 216 if entity @a[distance=..8] run {
        scoreboard players set enable_remix ak.state 0
        tag @a add c
        function animatronic:remix/opening/place.animatronic
    }
}

function dialogue_start {
    sequence {
        stopsound @a master
        scoreboard players set cutscene_active ak.state 0
        playsound minecraft:entity.minecart.riding master @a -23.5 -58.0 195.3 100 1 1
        delay 1s
        gamemode adventure @a
        tp @a -23.5 -59.0 195.3
        effect clear @a saturation
        function audio:ambient/start
        delay 470t
        title @a times 0 200 0
        title @a title {"text":"B","font":"cursor"}
        execute at @a run playsound minecraft:entity.wolf.pant master @a ~ ~ ~ 10 1 1
        delay 1s
        kill @e[tag=animatronic]
        delay 3s
        title @a title ""
        tag @a add crosshair
        delay 3s
        scoreboard players set enable_remix ak.state 1
    }
}

function dialogue_bonnie {
    # tellraw @a ["","[",{"text":"Bonnie","bold":true,"color":"dark_purple"},"] ","My-my guitar! Where is it?"]
    execute at @a run playsound minecraft:entity.firework_rocket.twinkle_far master @a ~ ~ ~ 100 1 1
}

function dialogue_chica {
    # tellraw @a ["","[",{"text":"Chica","bold":true,"color":"yellow"},"] ","Carl? Caaarll? Freddy, have you seen carl?"]
    execute at @a run playsound minecraft:entity.firework_rocket.launch master @a ~ ~ ~ 100 1 1
}

function dialogue_freddy {
    # tellraw @a ["","[",{"text":"Freddy","bold":true,"color":"#800000"},"] ","Where did I leave that microphone.. I swear if you took it.."]
    execute at @a run playsound minecraft:entity.creeper.hurt master @a ~ ~ ~ 100 1 1
}

function dialogue_foxy {
    # tellraw @a ["","[",{"text":"Foxy","bold":true,"color":"dark_red"},"] ","Hahaha where are ya! When I find ya I’ll be havin you for lunch.."]
    execute at @a run playsound minecraft:entity.firework_rocket.twinkle master @a ~ ~ ~ 100 1 1
    schedule 11s append {
        execute as @e[tag=child] at @s run function audio:kid_crying
    }
}

function dialogue_golden_freddy {
    execute at @a run playsound minecraft:generic.kid_crying master @a ~ ~ ~ 0.1
    sequence {
        execute at @a run playsound dialogue.golden_freddy master @a ~ ~ ~ 100 1 1
        delay 6s
        function animatronic:remix/golden_freddy/spawn
    }
}

function dialogue_final_wave {
    sequence {
        execute at @a run playsound dialogue.final_wave master @a ~ ~ ~ 100 1 1
        delay 15t
        scoreboard players set remix_mode_active ak.state 1
        function animatronic:remix/golden_freddy/activate_friends
    }
}

function cutscene_2_classic {
    stopsound @a master generic.lobby.loop
    tag @a remove crosshair
    title @a times 0t 80t 40t
    scoreboard players set cutscene_active ak.state 1
    sequence {
        title @a subtitle {"text":"B","font":"cursor"}
        LOOP(40,i) {
            title @a title ["",{"text":"Y","color":"<%["green","red","yellow","gold","blue","white","light_purple","aqua"][i]%>"},{"text":"o","color":"<%["green","red","yellow","gold","blue","white","light_purple","aqua"][(i+1)%8]%>"},{"text":"u","color":"<%["green","red","yellow","gold","blue","white","light_purple","aqua"][(i+2)%8]%>"},{"text":" w","color":"<%["green","red","yellow","gold","blue","white","light_purple","aqua"][(i+3)%8]%>"},{"text":"o","color":"<%["green","red","yellow","gold","blue","white","light_purple","aqua"][(i+4)%8]%>"},{"text":"n","color":"<%["green","red","yellow","gold","blue","white","light_purple","aqua"][(i+5)%8]%>"},{"text":"!","color":"<%["green","red","yellow","gold","blue","white","light_purple","aqua"][(i+6)%8]%>"}]
            delay 1t
        }
        LOOP(20,i) {
            title @a title ["",{"text":"Y","color":"<%["green","red","yellow","gold","blue","white","light_purple","aqua"][i]%>"},{"text":"o","color":"<%["green","red","yellow","gold","blue","white","light_purple","aqua"][(i+1)%8]%>"},{"text":"u","color":"<%["green","red","yellow","gold","blue","white","light_purple","aqua"][(i+2)%8]%>"},{"text":" w","color":"<%["green","red","yellow","gold","blue","white","light_purple","aqua"][(i+3)%8]%>"},{"text":"o","color":"<%["green","red","yellow","gold","blue","white","light_purple","aqua"][(i+4)%8]%>"},{"text":"n","color":"<%["green","red","yellow","gold","blue","white","light_purple","aqua"][(i+5)%8]%>"},{"text":"!","color":"<%["green","red","yellow","gold","blue","white","light_purple","aqua"][(i+6)%8]%>"}]
            delay <%Math.floor(i/2)%>t
        }
        execute at @a run playsound minecraft:entity.firework_rocket.blast master @a
        LOOP(30,i) {
            title @a title ["",{"text":"Y","color":"dark_red"},{"text":"o","color":"dark_red"},{"text":"u","color":"dark_red"},{"text":" w","color":"dark_red"},{"text":"o","color":"dark_red"},{"text":"n","color":"dark_red"},{"text":"!","color":"dark_red"}]
            delay 1t
        }
        LOOP(30,i) {
            title @a title ["",{"text":"Y","color":"dark_red","obfuscated":<%["true","false"][Math.round(Math.random())]%>},{"text":"o","color":"dark_red","obfuscated":<%["true","false"][Math.round(Math.random())]%>},{"text":"u","color":"dark_red","obfuscated":<%["true","false"][Math.round(Math.random())]%>},{"text":" w","color":"dark_red","obfuscated":<%["true","false"][Math.round(Math.random())]%>},{"text":"o","color":"dark_red","obfuscated":<%["true","false"][Math.round(Math.random())]%>},{"text":"n","color":"dark_red","obfuscated":<%["true","false"][Math.round(Math.random())]%>},{"text":"!","color":"dark_red","obfuscated":<%["true","false"][Math.round(Math.random())]%>}]
            delay 1t
        }
        gamemode spectator @a
        spectate @e[tag=cutscene,tag=freddy_walking,limit=1] @p
        execute positioned -13.0 -59.5 232.5 run summon item_display ~ ~ ~ {Rotation:[180.0f,0.0f],item:{id:"minecraft:potion", Count:1b,tag:{CustomModelData:990502,CustomPotionColor:0}}, Tags:["freddy_walking_cutscene"]}
        delay 8s
        item replace entity @e[tag=freddy_walking_cutscene] container.0 with potion{CustomModelData:990511,CustomPotionColor:0}
        LOOP(275,i){
            execute as @e[tag=freddy_walking_cutscene] at @s run tp @s ^ ^ ^0.035
            delay 1t
        }
        item replace entity @e[tag=freddy_walking_cutscene] container.0 with potion{CustomModelData:990502,CustomPotionColor:0}
        delay 7s
        scoreboard players set cutscene_active ak.state 0
        execute as @a run spectate
        function credits:start
    }
}

function cutscene_1 {
    stopsound @a master generic.lobby.loop
    execute positioned -23 -60 195 run function util:reset_camera_state
    scoreboard players set flashlight jc.temp 0
    scoreboard players set @a jc.temp 0
    tag @a remove crosshair
    stopsound @a master 
    scoreboard players set cutscene_active ak.state 1
    time set midnight

    # Open right door
    scoreboard players set right_door ak.state 0
	execute as @e[type=minecraft:armor_stand,tag=right_door,tag=mount] at @s run tp @s ~ ~3.1 ~
	fill -27 -60 195 -27 -58 194 minecraft:air
	item replace entity @e[type=item_display,tag=door_button,tag=right] container.0 with minecraft:fire_charge{CustomModelData:1105}

    # Open left door
	scoreboard players set left_door ak.state 0
	execute as @e[type=minecraft:armor_stand,tag=left_door,tag=mount] at @s run tp @s ~ ~3.1 ~
	fill -21 -60 194 -21 -58 195 minecraft:air
	item replace entity @e[type=item_display,tag=door_button,tag=left] container.0 with minecraft:fire_charge{CustomModelData:1105}

    kill @e[tag=office_door]

    sequence {
        title @a times 20 40 0
        title @a title ""
        title @a subtitle {"text":"B","font":"cursor"}
        delay 20t
        title @a times 20 40 10
        title @a subtitle ""
        title @a actionbar {"text":"B","font":"cursor"}
        title @a title {"text":"L","font":"cursor"}
        execute as @p at @s run playsound minecraft:entity.firework_rocket.blast_far master @a ~ ~ ~ 100 1 1
        setblock -6 -56 219 light
        setblock -4 -56 222 light
        setblock -4 -56 217 light
        setblock -4 -60 217 light
        setblock -4 -60 222 light
        setblock -8 -60 222 light
        setblock -8 -60 217 light
        setblock -8 -56 217 light
        setblock -8 -56 222 light
        
        gamemode spectator @a
        spectate @e[tag=cutscene,tag=outside,limit=1] @p
        delay 150t
        spectate @e[tag=cutscene,tag=stage,limit=1] @p
        function animatronic:generic/spawn
        delay 280t
        spectate @e[tag=cutscene,tag=another_room,limit=1] @p
        delay 87t
        fill -8 -60 222 -4 -56 217 air replace light
        delay 70t
        spectate @e[tag=cutscene,tag=stage,limit=1] @p
        delay 70t
        title @a times 0 200 0

        scoreboard players set gamemode save 1
        function animatronic:classic/foxy/spawn
        tp @e[tag=foxy] -18.0 -60 210 180 0
        function animatronic:classic/foxy/trigger
        delay 10t
        spectate @e[tag=cam_2b_cutscene,limit=1] @p
        delay 8s
        scoreboard players set gamemode save 2
        delay 2s
        function animatronic:remix/start
        function battery:summon_battery
        function cutscene:dialogue_start
    }
}

function cutscene_2 {
    stopsound @a master generic.lobby.loop
    tag @a remove crosshair
    scoreboard players set cutscene_active ak.state 1
    effect clear @a saturation
    sequence {
        setblock -25 -60 242 air
        setblock -25 -59 242 air
        setblock -26 -60 242 air
        setblock -26 -59 242 air
        setblock -25 -60 242 iron_door[half=lower,hinge=right,open=false] replace
        setblock -25 -59 242 iron_door[half=upper,hinge=right,open=false] replace
        setblock -26 -60 242 iron_door[half=lower,hinge=left,open=false] replace
        setblock -26 -59 242 iron_door[half=upper,hinge=left,open=false] replace
        playsound entity.wolf.death master @a -25 -60 242 1 2

        delay 4t
        setblock -22 -60 242 air
        setblock -22 -59 242 air
        setblock -23 -60 242 air
        setblock -23 -59 242 air
        setblock -22 -60 242 iron_door[half=lower,hinge=right,open=false] replace
        setblock -22 -59 242 iron_door[half=upper,hinge=right,open=false] replace
        setblock -23 -60 242 iron_door[half=lower,hinge=left,open=false] replace
        setblock -23 -59 242 iron_door[half=upper,hinge=left,open=false] replace
        playsound entity.wolf.death master @a -23 -59 242 1 2
        delay 20t
        playsound minecraft:generic.cutscene_2 master @a -23 -59 242 100 1 1
        delay 550t
        # delay 20t
        # playsound minecraft:entity.zombie.attack_iron_door master @a -23 -59 242 0.1
        # playsound minecraft:entity.chicken.step master @a -23 -59 242
        # playsound minecraft:entity.chicken.step master @a -25 -60 242
        # tellraw @a ["","[",{"text":"Animatronic","bold":true,"color":"dark_gray"},"] ","Let us out!"]
        # delay 10t
        # tellraw @a ["","[",{"text":"Animatronic","bold":true,"color":"dark_gray"},"] ","We won't hurt you!"]
        # delay 10t
        # tellraw @a ["","[",{"text":"Animatronic","bold":true,"color":"dark_gray"},"] ","Please!"]
        # delay 10t
        # tellraw @a ["","[",{"text":"Animatronic","bold":true,"color":"dark_gray"},"] ","Help me!"]
        # delay 10t
        # tellraw @a ["","[",{"text":"Animatronic","bold":true,"color":"dark_gray"},"] ","Please!"]
        # delay 10t
        # tellraw @a ["","[",{"text":"Animatronic","bold":true,"color":"dark_gray"},"] ","No!"]
        # delay 8s
        execute at @a run playsound entity.horse.death master @a
        title @a times 40t 80t 40t
        title @a subtitle {"text":"B","font":"cursor"}
        title @a title ["",{"text":"\uEF00","font":"6am"},{"text":" AM","bold":true}]
        title @a subtitle {"text":"B","font":"cursor"}
        delay 2s
        title @a times 0t 10t 20t
        LOOP(72,i) {
            title @a title ["",{"text":"\uEF<%i.toLocaleString('en-US',{minimumIntegerDigits:2,useGrouping:false})%>","font":"6am"},{"text":" AM","bold":true}]
            title @a subtitle {"text":"B","font":"cursor"}
            delay 1t
        }
        LOOP(120,i) {
            title @a title ["",{"text":"\uEF71","font":"6am"},{"text":" AM","bold":true}]
            title @a subtitle {"text":"B","font":"cursor"}
            delay 1t 
        }
        execute at @a run playsound entity.wolf.death master @a ~ ~ ~
        execute at @a run playsound entity.wolf.death master @a ~ ~ ~
        execute at @a run playsound entity.cow.step master @a ~ ~ ~
        execute at @a run playsound entity.cow.step master @a ~ ~ ~
        LOOP(70,i) {
            title @a times 0t 10t 20t
            title @a title ["",{"text":"\uEF71","font":"6am"},{"text":" AM","bold":true}]
            title @a subtitle {"text":"B","font":"cursor"}
            delay 1t 
        }
        stopsound @a master entity.cow.step
        delay 20t

        title @a times 10t 70t 20t

        scoreboard players set cutscene_active ak.state 0
        gamemode adventure @p
        function credits:start
        fill -63 -60 185 16 -61 243 cave_air replace fire
        function animatronic:remix/reset
    }
}